/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.Arrays;
import net.dries007.tfc.TerraFirmaCraft;

public class SimpleCraftMatrix {
    private static final int MAX_WIDTH = 5;
    private static final int MAX_HEIGHT = 5;
    private static final int MAX_AREA = 25;
    private final boolean[] matrix;
    private final boolean outsideSlot;
    private final int width;
    private final int height;
    private final int area;

    private static void logMatrix(boolean[] matrix) {
        StringBuilder b = new StringBuilder();
        for (boolean m : matrix) {
            b.append(m ? "X" : " ");
        }
        TerraFirmaCraft.getLog().debug("Matrix: {" + b.toString() + "}");
    }

    public SimpleCraftMatrix() {
        this.width = 5;
        this.height = 5;
        this.area = 25;
        this.matrix = new boolean[25];
        this.outsideSlot = false;
        Arrays.fill(this.matrix, true);
    }

    public SimpleCraftMatrix(boolean outsideSlotRequired, String ... pattern) {
        if (pattern.length == 0 || pattern.length > 5) {
            throw new IllegalArgumentException("Pattern height is invalid");
        }
        this.height = pattern.length;
        this.width = pattern[0].length();
        this.area = this.width * this.height;
        this.matrix = new boolean[this.width * this.height];
        this.outsideSlot = outsideSlotRequired;
        if (this.width > 5) {
            throw new IllegalArgumentException("Pattern width is invalid");
        }
        for (int i = 0; i < this.height; ++i) {
            String line = pattern[i];
            if (line.length() != this.width) {
                throw new IllegalArgumentException("Line " + i + " in the pattern has the incorrect length");
            }
            for (int c = 0; c < this.width; ++c) {
                this.matrix[i * this.width + c] = line.charAt(c) != ' ';
            }
        }
    }

    public void setAll(boolean value) {
        for (int i = 0; i < this.width * this.height; ++i) {
            this.set(i, value);
        }
    }

    public void set(int xPos, int yPos, boolean value) {
        this.set(xPos + yPos * this.width, value);
    }

    public void set(int index, boolean value) {
        if (index >= 0 && index < this.area) {
            this.matrix[index] = value;
        }
    }

    public boolean get(int xPos, int yPos) {
        return this.get(xPos + yPos * this.width);
    }

    public boolean get(int index) {
        return index >= 0 && index < this.area && this.matrix[index];
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isEqual(SimpleCraftMatrix other) {
        if (other.width != this.width || other.height != this.height) {
            return false;
        }
        for (int i = 0; i < this.width * this.height; ++i) {
            if (other.matrix[i] == this.matrix[i]) continue;
            return false;
        }
        return true;
    }

    public boolean matches(SimpleCraftMatrix other) {
        for (int xShift = 0; xShift <= this.width - other.width; ++xShift) {
            for (int yShift = 0; yShift <= this.height - other.height; ++yShift) {
                if (this.matches(other, xShift, yShift, false)) {
                    return true;
                }
                if (!this.matches(other, xShift, yShift, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(SimpleCraftMatrix other, int startX, int startY, boolean isMirrored) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int otherIdx;
                int patternIdx = y * this.width + x;
                if (!(x < startX || y < startY || x - startX >= other.width || y - startY >= other.height ? this.matrix[patternIdx] != other.outsideSlot : this.matrix[patternIdx] != other.matrix[otherIdx = isMirrored ? (y - startY) * other.width + (other.width - 1 - (x - startX)) : (y - startY) * other.width + (x - startX)])) continue;
                return false;
            }
        }
        return true;
    }
}

